/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.queue;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.queue.Member;
import java.net.URI;

public class MemberUpdater
extends Updater<Member> {
    private String pathQueueSid;
    private String pathCallSid;
    private URI url;
    private String pathAccountSid;
    private HttpMethod method;

    public MemberUpdater(String pathQueueSid, String pathCallSid, URI url) {
        this.pathQueueSid = pathQueueSid;
        this.pathCallSid = pathCallSid;
        this.url = url;
    }

    public MemberUpdater(String pathAccountSid, String pathQueueSid, String pathCallSid, URI url) {
        this.pathAccountSid = pathAccountSid;
        this.pathQueueSid = pathQueueSid;
        this.pathCallSid = pathCallSid;
        this.url = url;
    }

    public MemberUpdater setUrl(URI url) {
        this.url = url;
        return this;
    }

    public MemberUpdater setUrl(String url) {
        return this.setUrl(Promoter.uriFromString(url));
    }

    public MemberUpdater setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public Member update(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Queues/{QueueSid}/Members/{CallSid}.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{QueueSid}", this.pathQueueSid.toString());
        path = path.replace("{CallSid}", this.pathCallSid.toString());
        path = path.replace("{Url}", this.url.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Member.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.url != null) {
            request.addPostParam("Url", this.url.toString());
        }
        if (this.method != null) {
            request.addPostParam("Method", this.method.toString());
        }
    }
}

