/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.credentiallist;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.credentiallist.Credential;

public class CredentialCreator
extends Creator<Credential> {
    private String pathCredentialListSid;
    private String username;
    private String password;
    private String pathAccountSid;

    public CredentialCreator(String pathCredentialListSid, String username, String password) {
        this.pathCredentialListSid = pathCredentialListSid;
        this.username = username;
        this.password = password;
    }

    public CredentialCreator(String pathAccountSid, String pathCredentialListSid, String username, String password) {
        this.pathAccountSid = pathAccountSid;
        this.pathCredentialListSid = pathCredentialListSid;
        this.username = username;
        this.password = password;
    }

    public CredentialCreator setUsername(String username) {
        this.username = username;
        return this;
    }

    public CredentialCreator setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public Credential create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/SIP/CredentialLists/{CredentialListSid}/Credentials.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{CredentialListSid}", this.pathCredentialListSid.toString());
        path = path.replace("{Username}", this.username.toString());
        path = path.replace("{Password}", this.password.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Credential creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Credential.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.username != null) {
            request.addPostParam("Username", this.username);
        }
        if (this.password != null) {
            request.addPostParam("Password", this.password);
        }
    }
}

