/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddress;

public class IpAddressReader
extends Reader<IpAddress> {
    private String pathIpAccessControlListSid;
    private String pathAccountSid;
    private Integer pageSize;

    public IpAddressReader(String pathIpAccessControlListSid) {
        this.pathIpAccessControlListSid = pathIpAccessControlListSid;
    }

    public IpAddressReader(String pathAccountSid, String pathIpAccessControlListSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathIpAccessControlListSid = pathIpAccessControlListSid;
    }

    public IpAddressReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<IpAddress> read(TwilioRestClient client) {
        return new ResourceSet<IpAddress>(this, client, this.firstPage(client));
    }

    @Override
    public Page<IpAddress> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/SIP/IpAccessControlLists/{IpAccessControlListSid}/IpAddresses.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{IpAccessControlListSid}", this.pathIpAccessControlListSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<IpAddress> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAddress read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("ip_addresses", response.getContent(), IpAddress.class, client.getObjectMapper());
    }

    @Override
    public Page<IpAddress> previousPage(Page<IpAddress> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IpAddress> nextPage(Page<IpAddress> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IpAddress> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

