/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.bulkexports.v1.ExportConfiguration;

public class ExportConfigurationFetcher
extends Fetcher<ExportConfiguration> {
    private String pathResourceType;

    public ExportConfigurationFetcher(String pathResourceType) {
        this.pathResourceType = pathResourceType;
    }

    @Override
    public ExportConfiguration fetch(TwilioRestClient client) {
        String path = "/v1/Exports/{ResourceType}/Configuration";
        path = path.replace("{ResourceType}", this.pathResourceType.toString());
        Request request = new Request(HttpMethod.GET, Domains.BULKEXPORTS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExportConfiguration fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ExportConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }
}

