/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1.export;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.bulkexports.v1.export.ExportCustomJob;

public class ExportCustomJobReader
extends Reader<ExportCustomJob> {
    private String pathResourceType;
    private Integer pageSize;

    public ExportCustomJobReader(String pathResourceType) {
        this.pathResourceType = pathResourceType;
    }

    public ExportCustomJobReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<ExportCustomJob> read(TwilioRestClient client) {
        return new ResourceSet<ExportCustomJob>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ExportCustomJob> firstPage(TwilioRestClient client) {
        String path = "/v1/Exports/{ResourceType}/Jobs";
        path = path.replace("{ResourceType}", this.pathResourceType.toString());
        Request request = new Request(HttpMethod.GET, Domains.BULKEXPORTS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<ExportCustomJob> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExportCustomJob read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("jobs", response.getContent(), ExportCustomJob.class, client.getObjectMapper());
    }

    @Override
    public Page<ExportCustomJob> previousPage(Page<ExportCustomJob> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.BULKEXPORTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ExportCustomJob> nextPage(Page<ExportCustomJob> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.BULKEXPORTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ExportCustomJob> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

