/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v2.service.User;

public class UserReader
extends Reader<User> {
    private String pathServiceSid;
    private Integer pageSize;

    public UserReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public UserReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<User> read(TwilioRestClient client) {
        return new ResourceSet<User>(this, client, this.firstPage(client));
    }

    @Override
    public Page<User> firstPage(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Users";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.CHAT.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<User> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("users", response.getContent(), User.class, client.getObjectMapper());
    }

    @Override
    public Page<User> previousPage(Page<User> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CHAT.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<User> nextPage(Page<User> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CHAT.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<User> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

