/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.chat.v2.service.channel.WebhookCreator;
import com.twilio.rest.chat.v2.service.channel.WebhookDeleter;
import com.twilio.rest.chat.v2.service.channel.WebhookFetcher;
import com.twilio.rest.chat.v2.service.channel.WebhookReader;
import com.twilio.rest.chat.v2.service.channel.WebhookUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Webhook
extends Resource {
    private static final long serialVersionUID = 201752828404640L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String channelSid;
    private final String type;
    private final URI url;
    private final Map<String, Object> configuration;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    public static WebhookCreator creator(String pathServiceSid, String pathChannelSid, Type type) {
        return new WebhookCreator(pathServiceSid, pathChannelSid, type);
    }

    public static WebhookDeleter deleter(String pathServiceSid, String pathChannelSid, String pathSid) {
        return new WebhookDeleter(pathServiceSid, pathChannelSid, pathSid);
    }

    public static WebhookFetcher fetcher(String pathServiceSid, String pathChannelSid, String pathSid) {
        return new WebhookFetcher(pathServiceSid, pathChannelSid, pathSid);
    }

    public static WebhookReader reader(String pathServiceSid, String pathChannelSid) {
        return new WebhookReader(pathServiceSid, pathChannelSid);
    }

    public static WebhookUpdater updater(String pathServiceSid, String pathChannelSid, String pathSid) {
        return new WebhookUpdater(pathServiceSid, pathChannelSid, pathSid);
    }

    public static Webhook fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Webhook fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Webhook(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="channel_sid") String channelSid, @JsonProperty(value="type") String type, @JsonProperty(value="url") URI url, @JsonProperty(value="configuration") Map<String, Object> configuration, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.channelSid = channelSid;
        this.type = type;
        this.url = url;
        this.configuration = configuration;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getChannelSid() {
        return this.channelSid;
    }

    public final String getType() {
        return this.type;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook other = (Webhook)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.channelSid, other.channelSid) && Objects.equals(this.type, other.type) && Objects.equals(this.url, other.url) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.channelSid, this.type, this.url, this.configuration, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return "Webhook(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", channelSid=" + this.getChannelSid() + ", type=" + this.getType() + ", url=" + this.getUrl() + ", configuration=" + this.getConfiguration() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ")";
    }

    public static enum Type {
        WEBHOOK("webhook"),
        TRIGGER("trigger"),
        STUDIO("studio");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return (Type)Promoter.enumFromString((String)value, (Enum[])Type.values());
        }
    }

    public static enum Method {
        GET("GET"),
        POST("POST");

        private final String value;

        private Method(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Method forValue(String value) {
            return (Method)Promoter.enumFromString((String)value, (Enum[])Method.values());
        }
    }
}

