/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.content.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.content.v1.ContentAndApprovals;

public class ContentAndApprovalsReader
extends Reader<ContentAndApprovals> {
    private Integer pageSize;

    public ContentAndApprovalsReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<ContentAndApprovals> read(TwilioRestClient client) {
        return new ResourceSet<ContentAndApprovals>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ContentAndApprovals> firstPage(TwilioRestClient client) {
        String path = "/v1/ContentAndApprovals";
        Request request = new Request(HttpMethod.GET, Domains.CONTENT.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<ContentAndApprovals> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ContentAndApprovals read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("contents", response.getContent(), ContentAndApprovals.class, client.getObjectMapper());
    }

    @Override
    public Page<ContentAndApprovals> previousPage(Page<ContentAndApprovals> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CONTENT.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ContentAndApprovals> nextPage(Page<ContentAndApprovals> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CONTENT.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ContentAndApprovals> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

