/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.content.v1.content;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.content.v1.content.ApprovalCreate;

public class ApprovalCreateCreator
extends Creator<ApprovalCreate> {
    private String pathContentSid;
    private ApprovalCreate.ContentApprovalRequest contentApprovalRequest;

    public ApprovalCreateCreator(String pathContentSid, ApprovalCreate.ContentApprovalRequest contentApprovalRequest) {
        this.pathContentSid = pathContentSid;
        this.contentApprovalRequest = contentApprovalRequest;
    }

    public ApprovalCreateCreator setContentApprovalRequest(ApprovalCreate.ContentApprovalRequest contentApprovalRequest) {
        this.contentApprovalRequest = contentApprovalRequest;
        return this;
    }

    @Override
    public ApprovalCreate create(TwilioRestClient client) {
        String path = "/v1/Content/{ContentSid}/ApprovalRequests/whatsapp";
        path = path.replace("{ContentSid}", this.pathContentSid.toString());
        path = path.replace("{ContentApprovalRequest}", this.contentApprovalRequest.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONTENT.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request, client);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ApprovalCreate creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ApprovalCreate.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request, TwilioRestClient client) {
        ObjectMapper objectMapper = client.getObjectMapper();
        if (this.contentApprovalRequest != null) {
            request.setBody(ApprovalCreate.toJson(this.contentApprovalRequest, objectMapper));
        }
    }
}

