/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.configuration;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.configuration.Webhook;
import java.net.URI;
import java.util.List;

public class WebhookUpdater
extends Updater<Webhook> {
    private String pathChatServiceSid;
    private URI preWebhookUrl;
    private URI postWebhookUrl;
    private List<String> filters;
    private String method;

    public WebhookUpdater(String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    public WebhookUpdater setPreWebhookUrl(URI preWebhookUrl) {
        this.preWebhookUrl = preWebhookUrl;
        return this;
    }

    public WebhookUpdater setPreWebhookUrl(String preWebhookUrl) {
        return this.setPreWebhookUrl(Promoter.uriFromString(preWebhookUrl));
    }

    public WebhookUpdater setPostWebhookUrl(URI postWebhookUrl) {
        this.postWebhookUrl = postWebhookUrl;
        return this;
    }

    public WebhookUpdater setPostWebhookUrl(String postWebhookUrl) {
        return this.setPostWebhookUrl(Promoter.uriFromString(postWebhookUrl));
    }

    public WebhookUpdater setFilters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public WebhookUpdater setFilters(String filters) {
        return this.setFilters(Promoter.listOfOne(filters));
    }

    public WebhookUpdater setMethod(String method) {
        this.method = method;
        return this;
    }

    @Override
    public Webhook update(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Configuration/Webhooks";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.preWebhookUrl != null) {
            request.addPostParam("PreWebhookUrl", this.preWebhookUrl.toString());
        }
        if (this.postWebhookUrl != null) {
            request.addPostParam("PostWebhookUrl", this.postWebhookUrl.toString());
        }
        if (this.filters != null) {
            for (String prop : this.filters) {
                request.addPostParam("Filters", prop);
            }
        }
        if (this.method != null) {
            request.addPostParam("Method", this.method);
        }
    }
}

