/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.events.v1.schema.SchemaVersionFetcher;
import com.twilio.rest.events.v1.schema.SchemaVersionReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaVersion
extends Resource {
    private static final long serialVersionUID = 232564429627083L;
    private final String id;
    private final Integer schemaVersion;
    private final ZonedDateTime dateCreated;
    private final URI url;
    private final URI raw;

    public static SchemaVersionFetcher fetcher(String pathId, Integer pathSchemaVersion) {
        return new SchemaVersionFetcher(pathId, pathSchemaVersion);
    }

    public static SchemaVersionReader reader(String pathId) {
        return new SchemaVersionReader(pathId);
    }

    public static SchemaVersion fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SchemaVersion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SchemaVersion fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SchemaVersion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SchemaVersion(@JsonProperty(value="id") String id, @JsonProperty(value="schema_version") Integer schemaVersion, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url, @JsonProperty(value="raw") URI raw) {
        this.id = id;
        this.schemaVersion = schemaVersion;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
        this.raw = raw;
    }

    public final String getId() {
        return this.id;
    }

    public final Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final URI getRaw() {
        return this.raw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaVersion other = (SchemaVersion)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.schemaVersion, other.schemaVersion) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url) && Objects.equals(this.raw, other.raw);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.schemaVersion, this.dateCreated, this.url, this.raw);
    }

    public String toString() {
        return "SchemaVersion(id=" + this.getId() + ", schemaVersion=" + this.getSchemaVersion() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ", raw=" + this.getRaw() + ")";
    }
}

