/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.Assessments;
import java.math.BigDecimal;

public class AssessmentsCreator
extends Creator<Assessments> {
    private String categorySid;
    private String categoryName;
    private String segmentId;
    private String agentId;
    private BigDecimal offset;
    private String metricId;
    private String metricName;
    private String answerText;
    private String answerId;
    private String questionnaireSid;
    private String authorization;

    public AssessmentsCreator(String categorySid, String categoryName, String segmentId, String agentId, BigDecimal offset, String metricId, String metricName, String answerText, String answerId, String questionnaireSid) {
        this.categorySid = categorySid;
        this.categoryName = categoryName;
        this.segmentId = segmentId;
        this.agentId = agentId;
        this.offset = offset;
        this.metricId = metricId;
        this.metricName = metricName;
        this.answerText = answerText;
        this.answerId = answerId;
        this.questionnaireSid = questionnaireSid;
    }

    public AssessmentsCreator setCategorySid(String categorySid) {
        this.categorySid = categorySid;
        return this;
    }

    public AssessmentsCreator setCategoryName(String categoryName) {
        this.categoryName = categoryName;
        return this;
    }

    public AssessmentsCreator setSegmentId(String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    public AssessmentsCreator setAgentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    public AssessmentsCreator setOffset(BigDecimal offset) {
        this.offset = offset;
        return this;
    }

    public AssessmentsCreator setMetricId(String metricId) {
        this.metricId = metricId;
        return this;
    }

    public AssessmentsCreator setMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public AssessmentsCreator setAnswerText(String answerText) {
        this.answerText = answerText;
        return this;
    }

    public AssessmentsCreator setAnswerId(String answerId) {
        this.answerId = answerId;
        return this;
    }

    public AssessmentsCreator setQuestionnaireSid(String questionnaireSid) {
        this.questionnaireSid = questionnaireSid;
        return this;
    }

    public AssessmentsCreator setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    @Override
    public Assessments create(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Assessments";
        path = path.replace("{CategorySid}", this.categorySid.toString());
        path = path.replace("{CategoryName}", this.categoryName.toString());
        path = path.replace("{SegmentId}", this.segmentId.toString());
        path = path.replace("{AgentId}", this.agentId.toString());
        path = path.replace("{Offset}", this.offset.toString());
        path = path.replace("{MetricId}", this.metricId.toString());
        path = path.replace("{MetricName}", this.metricName.toString());
        path = path.replace("{AnswerText}", this.answerText.toString());
        path = path.replace("{AnswerId}", this.answerId.toString());
        path = path.replace("{QuestionnaireSid}", this.questionnaireSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Assessments creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Assessments.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.categorySid != null) {
            request.addPostParam("CategorySid", this.categorySid);
        }
        if (this.categoryName != null) {
            request.addPostParam("CategoryName", this.categoryName);
        }
        if (this.segmentId != null) {
            request.addPostParam("SegmentId", this.segmentId);
        }
        if (this.agentId != null) {
            request.addPostParam("AgentId", this.agentId);
        }
        if (this.offset != null) {
            request.addPostParam("Offset", this.offset.toString());
        }
        if (this.metricId != null) {
            request.addPostParam("MetricId", this.metricId);
        }
        if (this.metricName != null) {
            request.addPostParam("MetricName", this.metricName);
        }
        if (this.answerText != null) {
            request.addPostParam("AnswerText", this.answerText);
        }
        if (this.answerId != null) {
            request.addPostParam("AnswerId", this.answerId);
        }
        if (this.questionnaireSid != null) {
            request.addPostParam("QuestionnaireSid", this.questionnaireSid);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }
}

