/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InsightsUserRolesFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InsightsUserRoles
extends Resource {
    private static final long serialVersionUID = 154216272914379L;
    private final List<String> roles;
    private final URI url;

    public static InsightsUserRolesFetcher fetcher() {
        return new InsightsUserRolesFetcher();
    }

    public static InsightsUserRoles fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsUserRoles.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InsightsUserRoles fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InsightsUserRoles.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InsightsUserRoles(@JsonProperty(value="roles") List<String> roles, @JsonProperty(value="url") URI url) {
        this.roles = roles;
        this.url = url;
    }

    public final List<String> getRoles() {
        return this.roles;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsUserRoles other = (InsightsUserRoles)o;
        return Objects.equals(this.roles, other.roles) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.roles, this.url);
    }

    public String toString() {
        return "InsightsUserRoles(roles=" + this.getRoles() + ", url=" + this.getUrl() + ")";
    }
}

