/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.PluginConfigurationArchiveUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PluginConfigurationArchive
extends Resource {
    private static final long serialVersionUID = 208571008215124L;
    private final String sid;
    private final String accountSid;
    private final String name;
    private final String description;
    private final Boolean archived;
    private final ZonedDateTime dateCreated;
    private final URI url;

    public static PluginConfigurationArchiveUpdater updater(String pathSid) {
        return new PluginConfigurationArchiveUpdater(pathSid);
    }

    public static PluginConfigurationArchive fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PluginConfigurationArchive.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PluginConfigurationArchive fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PluginConfigurationArchive.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PluginConfigurationArchive(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="archived") Boolean archived, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.name = name;
        this.description = description;
        this.archived = archived;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Boolean getArchived() {
        return this.archived;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginConfigurationArchive other = (PluginConfigurationArchive)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.archived, other.archived) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.name, this.description, this.archived, this.dateCreated, this.url);
    }

    public String toString() {
        return "PluginConfigurationArchive(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", archived=" + this.getArchived() + ", dateCreated=" + this.getDateCreated() + ", url=" + this.getUrl() + ")";
    }
}

