/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.Plugin;

public class PluginCreator
extends Creator<Plugin> {
    private String uniqueName;
    private String flexMetadata;
    private String friendlyName;
    private String description;

    public PluginCreator(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public PluginCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public PluginCreator setFlexMetadata(String flexMetadata) {
        this.flexMetadata = flexMetadata;
        return this;
    }

    public PluginCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public PluginCreator setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Plugin create(TwilioRestClient client) {
        String path = "/v1/PluginService/Plugins";
        path = path.replace("{UniqueName}", this.uniqueName.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Plugin creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Plugin.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.flexMetadata != null) {
            request.addHeaderParam("Flex-Metadata", this.flexMetadata);
        }
    }
}

