/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.WebChannel;

public class WebChannelUpdater
extends Updater<WebChannel> {
    private String pathSid;
    private WebChannel.ChatStatus chatStatus;
    private String postEngagementData;

    public WebChannelUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public WebChannelUpdater setChatStatus(WebChannel.ChatStatus chatStatus) {
        this.chatStatus = chatStatus;
        return this;
    }

    public WebChannelUpdater setPostEngagementData(String postEngagementData) {
        this.postEngagementData = postEngagementData;
        return this;
    }

    @Override
    public WebChannel update(TwilioRestClient client) {
        String path = "/v1/WebChannels/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WebChannel update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return WebChannel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.chatStatus != null) {
            request.addPostParam("ChatStatus", this.chatStatus.toString());
        }
        if (this.postEngagementData != null) {
            request.addPostParam("PostEngagementData", this.postEngagementData);
        }
    }
}

