/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.interaction.interactionchannel.InteractionChannelParticipantCreator;
import com.twilio.rest.flexapi.v1.interaction.interactionchannel.InteractionChannelParticipantReader;
import com.twilio.rest.flexapi.v1.interaction.interactionchannel.InteractionChannelParticipantUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InteractionChannelParticipant
extends Resource {
    private static final long serialVersionUID = 13330803139630L;
    private final String sid;
    private final Type type;
    private final String interactionSid;
    private final String channelSid;
    private final URI url;
    private final Map<String, Object> routingProperties;

    public static InteractionChannelParticipantCreator creator(String pathInteractionSid, String pathChannelSid, Type type, Map<String, Object> mediaProperties) {
        return new InteractionChannelParticipantCreator(pathInteractionSid, pathChannelSid, type, mediaProperties);
    }

    public static InteractionChannelParticipantReader reader(String pathInteractionSid, String pathChannelSid) {
        return new InteractionChannelParticipantReader(pathInteractionSid, pathChannelSid);
    }

    public static InteractionChannelParticipantUpdater updater(String pathInteractionSid, String pathChannelSid, String pathSid, Status status) {
        return new InteractionChannelParticipantUpdater(pathInteractionSid, pathChannelSid, pathSid, status);
    }

    public static InteractionChannelParticipant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InteractionChannelParticipant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InteractionChannelParticipant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, InteractionChannelParticipant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InteractionChannelParticipant(@JsonProperty(value="sid") String sid, @JsonProperty(value="type") Type type, @JsonProperty(value="interaction_sid") String interactionSid, @JsonProperty(value="channel_sid") String channelSid, @JsonProperty(value="url") URI url, @JsonProperty(value="routing_properties") Map<String, Object> routingProperties) {
        this.sid = sid;
        this.type = type;
        this.interactionSid = interactionSid;
        this.channelSid = channelSid;
        this.url = url;
        this.routingProperties = routingProperties;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getInteractionSid() {
        return this.interactionSid;
    }

    public final String getChannelSid() {
        return this.channelSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, Object> getRoutingProperties() {
        return this.routingProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InteractionChannelParticipant other = (InteractionChannelParticipant)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.interactionSid, other.interactionSid) && Objects.equals(this.channelSid, other.channelSid) && Objects.equals(this.url, other.url) && Objects.equals(this.routingProperties, other.routingProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.type, this.interactionSid, this.channelSid, this.url, this.routingProperties});
    }

    public String toString() {
        return "InteractionChannelParticipant(sid=" + this.getSid() + ", type=" + (Object)((Object)this.getType()) + ", interactionSid=" + this.getInteractionSid() + ", channelSid=" + this.getChannelSid() + ", url=" + this.getUrl() + ", routingProperties=" + this.getRoutingProperties() + ")";
    }

    public static enum Status {
        CLOSED("closed"),
        WRAPUP("wrapup");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Type {
        SUPERVISOR("supervisor"),
        CUSTOMER("customer"),
        EXTERNAL("external"),
        AGENT("agent"),
        UNKNOWN("unknown");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return (Type)Promoter.enumFromString((String)value, (Enum[])Type.values());
        }
    }
}

