/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.plugin;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.plugin.PluginVersions;
import java.net.URI;

public class PluginVersionsCreator
extends Creator<PluginVersions> {
    private String pathPluginSid;
    private String version;
    private URI pluginUrl;
    private String flexMetadata;
    private String changelog;
    private Boolean _private;
    private String cliVersion;
    private String validateStatus;

    public PluginVersionsCreator(String pathPluginSid, String version, URI pluginUrl) {
        this.pathPluginSid = pathPluginSid;
        this.version = version;
        this.pluginUrl = pluginUrl;
    }

    public PluginVersionsCreator setVersion(String version) {
        this.version = version;
        return this;
    }

    public PluginVersionsCreator setPluginUrl(URI pluginUrl) {
        this.pluginUrl = pluginUrl;
        return this;
    }

    public PluginVersionsCreator setPluginUrl(String pluginUrl) {
        return this.setPluginUrl(Promoter.uriFromString(pluginUrl));
    }

    public PluginVersionsCreator setFlexMetadata(String flexMetadata) {
        this.flexMetadata = flexMetadata;
        return this;
    }

    public PluginVersionsCreator setChangelog(String changelog) {
        this.changelog = changelog;
        return this;
    }

    public PluginVersionsCreator set_private(Boolean _private) {
        this._private = _private;
        return this;
    }

    public PluginVersionsCreator setCliVersion(String cliVersion) {
        this.cliVersion = cliVersion;
        return this;
    }

    public PluginVersionsCreator setValidateStatus(String validateStatus) {
        this.validateStatus = validateStatus;
        return this;
    }

    @Override
    public PluginVersions create(TwilioRestClient client) {
        String path = "/v1/PluginService/Plugins/{PluginSid}/Versions";
        path = path.replace("{PluginSid}", this.pathPluginSid.toString());
        path = path.replace("{Version}", this.version.toString());
        path = path.replace("{PluginUrl}", this.pluginUrl.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PluginVersions creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PluginVersions.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.version != null) {
            request.addPostParam("Version", this.version);
        }
        if (this.pluginUrl != null) {
            request.addPostParam("PluginUrl", this.pluginUrl.toString());
        }
        if (this.changelog != null) {
            request.addPostParam("Changelog", this.changelog);
        }
        if (this._private != null) {
            request.addPostParam("Private", this._private.toString());
        }
        if (this.cliVersion != null) {
            request.addPostParam("CliVersion", this.cliVersion);
        }
        if (this.validateStatus != null) {
            request.addPostParam("ValidateStatus", this.validateStatus);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.flexMetadata != null) {
            request.addHeaderParam("Flex-Metadata", this.flexMetadata);
        }
    }
}

