/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v2.WebChannelsCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WebChannels
extends Resource {
    private static final long serialVersionUID = 110421660015552L;
    private final String conversationSid;
    private final String identity;

    public static WebChannelsCreator creator(String addressSid) {
        return new WebChannelsCreator(addressSid);
    }

    public static WebChannels fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WebChannels.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WebChannels fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WebChannels.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WebChannels(@JsonProperty(value="conversation_sid") String conversationSid, @JsonProperty(value="identity") String identity) {
        this.conversationSid = conversationSid;
        this.identity = identity;
    }

    public final String getConversationSid() {
        return this.conversationSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebChannels other = (WebChannels)o;
        return Objects.equals(this.conversationSid, other.conversationSid) && Objects.equals(this.identity, other.identity);
    }

    public int hashCode() {
        return Objects.hash(this.conversationSid, this.identity);
    }

    public String toString() {
        return "WebChannels(conversationSid=" + this.getConversationSid() + ", identity=" + this.getIdentity() + ")";
    }
}

