/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.Conference;

public class ConferenceReader
extends Reader<Conference> {
    private String conferenceSid;
    private String friendlyName;
    private String status;
    private String createdAfter;
    private String createdBefore;
    private String mixerRegion;
    private String tags;
    private String subaccount;
    private String detectedIssues;
    private String endReason;
    private Integer pageSize;

    public ConferenceReader setConferenceSid(String conferenceSid) {
        this.conferenceSid = conferenceSid;
        return this;
    }

    public ConferenceReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ConferenceReader setStatus(String status) {
        this.status = status;
        return this;
    }

    public ConferenceReader setCreatedAfter(String createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    public ConferenceReader setCreatedBefore(String createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    public ConferenceReader setMixerRegion(String mixerRegion) {
        this.mixerRegion = mixerRegion;
        return this;
    }

    public ConferenceReader setTags(String tags) {
        this.tags = tags;
        return this;
    }

    public ConferenceReader setSubaccount(String subaccount) {
        this.subaccount = subaccount;
        return this;
    }

    public ConferenceReader setDetectedIssues(String detectedIssues) {
        this.detectedIssues = detectedIssues;
        return this;
    }

    public ConferenceReader setEndReason(String endReason) {
        this.endReason = endReason;
        return this;
    }

    public ConferenceReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Conference> read(TwilioRestClient client) {
        return new ResourceSet<Conference>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Conference> firstPage(TwilioRestClient client) {
        String path = "/v1/Conferences";
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Conference> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conference read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("conferences", response.getContent(), Conference.class, client.getObjectMapper());
    }

    @Override
    public Page<Conference> previousPage(Page<Conference> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Conference> nextPage(Page<Conference> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Conference> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.conferenceSid != null) {
            request.addQueryParam("ConferenceSid", this.conferenceSid);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status);
        }
        if (this.createdAfter != null) {
            request.addQueryParam("CreatedAfter", this.createdAfter);
        }
        if (this.createdBefore != null) {
            request.addQueryParam("CreatedBefore", this.createdBefore);
        }
        if (this.mixerRegion != null) {
            request.addQueryParam("MixerRegion", this.mixerRegion);
        }
        if (this.tags != null) {
            request.addQueryParam("Tags", this.tags);
        }
        if (this.subaccount != null) {
            request.addQueryParam("Subaccount", this.subaccount);
        }
        if (this.detectedIssues != null) {
            request.addQueryParam("DetectedIssues", this.detectedIssues);
        }
        if (this.endReason != null) {
            request.addQueryParam("EndReason", this.endReason);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

