/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.Room;
import java.time.ZonedDateTime;
import java.util.List;

public class RoomReader
extends Reader<Room> {
    private List<Room.RoomType> roomType;
    private List<Room.Codec> codec;
    private String roomName;
    private ZonedDateTime createdAfter;
    private ZonedDateTime createdBefore;
    private Integer pageSize;

    public RoomReader setRoomType(List<Room.RoomType> roomType) {
        this.roomType = roomType;
        return this;
    }

    public RoomReader setRoomType(Room.RoomType roomType) {
        return this.setRoomType(Promoter.listOfOne(roomType));
    }

    public RoomReader setCodec(List<Room.Codec> codec) {
        this.codec = codec;
        return this;
    }

    public RoomReader setCodec(Room.Codec codec) {
        return this.setCodec(Promoter.listOfOne(codec));
    }

    public RoomReader setRoomName(String roomName) {
        this.roomName = roomName;
        return this;
    }

    public RoomReader setCreatedAfter(ZonedDateTime createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    public RoomReader setCreatedBefore(ZonedDateTime createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    public RoomReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Room> read(TwilioRestClient client) {
        return new ResourceSet<Room>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Room> firstPage(TwilioRestClient client) {
        String path = "/v1/Video/Rooms";
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Room> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Room read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("rooms", response.getContent(), Room.class, client.getObjectMapper());
    }

    @Override
    public Page<Room> previousPage(Page<Room> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Room> nextPage(Page<Room> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Room> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.roomType != null) {
            for (Room.RoomType roomType : this.roomType) {
                request.addQueryParam("RoomType", roomType.toString());
            }
        }
        if (this.codec != null) {
            for (Room.Codec codec : this.codec) {
                request.addQueryParam("Codec", codec.toString());
            }
        }
        if (this.roomName != null) {
            request.addQueryParam("RoomName", this.roomName);
        }
        if (this.createdAfter != null) {
            request.addQueryParam("CreatedAfter", this.createdAfter.toInstant().toString());
        }
        if (this.createdBefore != null) {
            request.addQueryParam("CreatedBefore", this.createdBefore.toInstant().toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

