/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.conference;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.conference.ConferenceParticipant;

public class ConferenceParticipantFetcher
extends Fetcher<ConferenceParticipant> {
    private String pathConferenceSid;
    private String pathParticipantSid;
    private String events;
    private String metrics;

    public ConferenceParticipantFetcher(String pathConferenceSid, String pathParticipantSid) {
        this.pathConferenceSid = pathConferenceSid;
        this.pathParticipantSid = pathParticipantSid;
    }

    public ConferenceParticipantFetcher setEvents(String events) {
        this.events = events;
        return this;
    }

    public ConferenceParticipantFetcher setMetrics(String metrics) {
        this.metrics = metrics;
        return this;
    }

    @Override
    public ConferenceParticipant fetch(TwilioRestClient client) {
        String path = "/v1/Conferences/{ConferenceSid}/Participants/{ParticipantSid}";
        path = path.replace("{ConferenceSid}", this.pathConferenceSid.toString());
        path = path.replace("{ParticipantSid}", this.pathParticipantSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConferenceParticipant fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ConferenceParticipant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.events != null) {
            request.addQueryParam("Events", this.events);
        }
        if (this.metrics != null) {
            request.addQueryParam("Metrics", this.metrics);
        }
    }
}

