/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.CustomOperator;
import java.util.Map;

public class CustomOperatorCreator
extends Creator<CustomOperator> {
    private String friendlyName;
    private String operatorType;
    private Map<String, Object> config;

    public CustomOperatorCreator(String friendlyName, String operatorType, Map<String, Object> config) {
        this.friendlyName = friendlyName;
        this.operatorType = operatorType;
        this.config = config;
    }

    public CustomOperatorCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public CustomOperatorCreator setOperatorType(String operatorType) {
        this.operatorType = operatorType;
        return this;
    }

    public CustomOperatorCreator setConfig(Map<String, Object> config) {
        this.config = config;
        return this;
    }

    @Override
    public CustomOperator create(TwilioRestClient client) {
        String path = "/v2/Operators/Custom";
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        path = path.replace("{OperatorType}", this.operatorType.toString());
        path = path.replace("{Config}", this.config.toString());
        Request request = new Request(HttpMethod.POST, Domains.INTELLIGENCE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CustomOperator creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return CustomOperator.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.operatorType != null) {
            request.addPostParam("OperatorType", this.operatorType);
        }
        if (this.config != null) {
            request.addPostParam("Config", Converter.mapToJson(this.config));
        }
    }
}

