/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.CustomOperator;
import java.util.Map;

public class CustomOperatorUpdater
extends Updater<CustomOperator> {
    private String pathSid;
    private String friendlyName;
    private Map<String, Object> config;
    private String ifMatch;

    public CustomOperatorUpdater(String pathSid, String friendlyName, Map<String, Object> config) {
        this.pathSid = pathSid;
        this.friendlyName = friendlyName;
        this.config = config;
    }

    public CustomOperatorUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public CustomOperatorUpdater setConfig(Map<String, Object> config) {
        this.config = config;
        return this;
    }

    public CustomOperatorUpdater setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    @Override
    public CustomOperator update(TwilioRestClient client) {
        String path = "/v2/Operators/Custom/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        path = path.replace("{Config}", this.config.toString());
        Request request = new Request(HttpMethod.POST, Domains.INTELLIGENCE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CustomOperator update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return CustomOperator.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.config != null) {
            request.addPostParam("Config", Converter.mapToJson(this.config));
        }
    }

    private void addHeaderParams(Request request) {
        if (this.ifMatch != null) {
            request.addHeaderParam("If-Match", this.ifMatch);
        }
    }
}

