/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.OperatorAttachment;

public class OperatorAttachmentCreator
extends Creator<OperatorAttachment> {
    private String pathServiceSid;
    private String pathOperatorSid;

    public OperatorAttachmentCreator(String pathServiceSid, String pathOperatorSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathOperatorSid = pathOperatorSid;
    }

    @Override
    public OperatorAttachment create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Operators/{OperatorSid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{OperatorSid}", this.pathOperatorSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.INTELLIGENCE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("OperatorAttachment creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return OperatorAttachment.fromJson(response.getStream(), client.getObjectMapper());
    }
}

