/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.intelligence.v2.OperatorAttachmentsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OperatorAttachments
extends Resource {
    private static final long serialVersionUID = 34922173315166L;
    private final String serviceSid;
    private final List<String> operatorSids;
    private final URI url;

    public static OperatorAttachmentsFetcher fetcher(String pathServiceSid) {
        return new OperatorAttachmentsFetcher(pathServiceSid);
    }

    public static OperatorAttachments fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OperatorAttachments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static OperatorAttachments fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OperatorAttachments.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private OperatorAttachments(@JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="operator_sids") List<String> operatorSids, @JsonProperty(value="url") URI url) {
        this.serviceSid = serviceSid;
        this.operatorSids = operatorSids;
        this.url = url;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final List<String> getOperatorSids() {
        return this.operatorSids;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorAttachments other = (OperatorAttachments)o;
        return Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.operatorSids, other.operatorSids) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.serviceSid, this.operatorSids, this.url);
    }

    public String toString() {
        return "OperatorAttachments(serviceSid=" + this.getServiceSid() + ", operatorSids=" + this.getOperatorSids() + ", url=" + this.getUrl() + ")";
    }
}

