/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.Service;

public class ServiceUpdater
extends Updater<Service> {
    private String pathSid;
    private String ifMatch;
    private Boolean autoTranscribe;
    private Boolean dataLogging;
    private String friendlyName;
    private String uniqueName;
    private Boolean autoRedaction;
    private Boolean mediaRedaction;
    private String webhookUrl;
    private Service.HttpMethod webhookHttpMethod;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    public ServiceUpdater setAutoTranscribe(Boolean autoTranscribe) {
        this.autoTranscribe = autoTranscribe;
        return this;
    }

    public ServiceUpdater setDataLogging(Boolean dataLogging) {
        this.dataLogging = dataLogging;
        return this;
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public ServiceUpdater setAutoRedaction(Boolean autoRedaction) {
        this.autoRedaction = autoRedaction;
        return this;
    }

    public ServiceUpdater setMediaRedaction(Boolean mediaRedaction) {
        this.mediaRedaction = mediaRedaction;
        return this;
    }

    public ServiceUpdater setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    public ServiceUpdater setWebhookHttpMethod(Service.HttpMethod webhookHttpMethod) {
        this.webhookHttpMethod = webhookHttpMethod;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        String path = "/v2/Services/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.INTELLIGENCE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.autoTranscribe != null) {
            request.addPostParam("AutoTranscribe", this.autoTranscribe.toString());
        }
        if (this.dataLogging != null) {
            request.addPostParam("DataLogging", this.dataLogging.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.autoRedaction != null) {
            request.addPostParam("AutoRedaction", this.autoRedaction.toString());
        }
        if (this.mediaRedaction != null) {
            request.addPostParam("MediaRedaction", this.mediaRedaction.toString());
        }
        if (this.webhookUrl != null) {
            request.addPostParam("WebhookUrl", this.webhookUrl);
        }
        if (this.webhookHttpMethod != null) {
            request.addPostParam("WebhookHttpMethod", this.webhookHttpMethod.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.ifMatch != null) {
            request.addHeaderParam("If-Match", this.ifMatch);
        }
    }
}

