/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.marketplace.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.marketplace.v1.ReferralConversionCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReferralConversion
extends Resource {
    private static final long serialVersionUID = 67114907443655L;
    private final String convertedAccountSid;

    public static ReferralConversionCreator creator(CreateReferralConversionRequest createReferralConversionRequest) {
        return new ReferralConversionCreator(createReferralConversionRequest);
    }

    public static ReferralConversion fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ReferralConversion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ReferralConversion fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ReferralConversion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ReferralConversion(@JsonProperty(value="converted_account_sid") String convertedAccountSid) {
        this.convertedAccountSid = convertedAccountSid;
    }

    public final String getConvertedAccountSid() {
        return this.convertedAccountSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferralConversion other = (ReferralConversion)o;
        return Objects.equals(this.convertedAccountSid, other.convertedAccountSid);
    }

    public int hashCode() {
        return Objects.hash(this.convertedAccountSid);
    }

    public String toString() {
        return "ReferralConversion(convertedAccountSid=" + this.getConvertedAccountSid() + ")";
    }

    public static class CreateReferralConversionRequest {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="referral_account_sid")
        private String referralAccountSid;

        public static CreateReferralConversionRequest fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, CreateReferralConversionRequest.class);
        }

        public String toString() {
            return "ReferralConversion.CreateReferralConversionRequest(referralAccountSid=" + this.getReferralAccountSid() + ")";
        }

        public String getReferralAccountSid() {
            return this.referralAccountSid;
        }

        @JsonProperty(value="referral_account_sid")
        public void setReferralAccountSid(String referralAccountSid) {
            this.referralAccountSid = referralAccountSid;
        }
    }
}

