/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.marketplace.v1.availableaddon;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.marketplace.v1.availableaddon.AvailableAddOnExtension;

public class AvailableAddOnExtensionFetcher
extends Fetcher<AvailableAddOnExtension> {
    private String pathAvailableAddOnSid;
    private String pathSid;

    public AvailableAddOnExtensionFetcher(String pathAvailableAddOnSid, String pathSid) {
        this.pathAvailableAddOnSid = pathAvailableAddOnSid;
        this.pathSid = pathSid;
    }

    @Override
    public AvailableAddOnExtension fetch(TwilioRestClient client) {
        String path = "/v1/AvailableAddOns/{AvailableAddOnSid}/Extensions/{Sid}";
        path = path.replace("{AvailableAddOnSid}", this.pathAvailableAddOnSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MARKETPLACE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AvailableAddOnExtension fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AvailableAddOnExtension.fromJson(response.getStream(), client.getObjectMapper());
    }
}

