/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.ExternalCampaignCreator;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExternalCampaign
extends Resource {
    private static final long serialVersionUID = 211920409391157L;
    private final String sid;
    private final String accountSid;
    private final String campaignId;
    private final String messagingServiceSid;
    private final ZonedDateTime dateCreated;

    public static ExternalCampaignCreator creator(String campaignId, String messagingServiceSid) {
        return new ExternalCampaignCreator(campaignId, messagingServiceSid);
    }

    public static ExternalCampaign fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ExternalCampaign.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ExternalCampaign fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ExternalCampaign.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ExternalCampaign(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="campaign_id") String campaignId, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="date_created") String dateCreated) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.campaignId = campaignId;
        this.messagingServiceSid = messagingServiceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCampaignId() {
        return this.campaignId;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalCampaign other = (ExternalCampaign)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.campaignId, other.campaignId) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.dateCreated, other.dateCreated);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.campaignId, this.messagingServiceSid, this.dateCreated);
    }

    public String toString() {
        return "ExternalCampaign(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", campaignId=" + this.getCampaignId() + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", dateCreated=" + this.getDateCreated() + ")";
    }
}

