/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.brandregistration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.brandregistration.BrandVettingCreator;
import com.twilio.rest.messaging.v1.brandregistration.BrandVettingFetcher;
import com.twilio.rest.messaging.v1.brandregistration.BrandVettingReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BrandVetting
extends Resource {
    private static final long serialVersionUID = 122020517475795L;
    private final String accountSid;
    private final String brandSid;
    private final String brandVettingSid;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime dateCreated;
    private final String vettingId;
    private final String vettingClass;
    private final String vettingStatus;
    private final VettingProvider vettingProvider;
    private final URI url;

    public static BrandVettingCreator creator(String pathBrandSid, VettingProvider vettingProvider) {
        return new BrandVettingCreator(pathBrandSid, vettingProvider);
    }

    public static BrandVettingFetcher fetcher(String pathBrandSid, String pathBrandVettingSid) {
        return new BrandVettingFetcher(pathBrandSid, pathBrandVettingSid);
    }

    public static BrandVettingReader reader(String pathBrandSid) {
        return new BrandVettingReader(pathBrandSid);
    }

    public static BrandVetting fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BrandVetting.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BrandVetting fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BrandVetting.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BrandVetting(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="brand_sid") String brandSid, @JsonProperty(value="brand_vetting_sid") String brandVettingSid, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="vetting_id") String vettingId, @JsonProperty(value="vetting_class") String vettingClass, @JsonProperty(value="vetting_status") String vettingStatus, @JsonProperty(value="vetting_provider") VettingProvider vettingProvider, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.brandSid = brandSid;
        this.brandVettingSid = brandVettingSid;
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.vettingId = vettingId;
        this.vettingClass = vettingClass;
        this.vettingStatus = vettingStatus;
        this.vettingProvider = vettingProvider;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBrandSid() {
        return this.brandSid;
    }

    public final String getBrandVettingSid() {
        return this.brandVettingSid;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final String getVettingId() {
        return this.vettingId;
    }

    public final String getVettingClass() {
        return this.vettingClass;
    }

    public final String getVettingStatus() {
        return this.vettingStatus;
    }

    public final VettingProvider getVettingProvider() {
        return this.vettingProvider;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandVetting other = (BrandVetting)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.brandSid, other.brandSid) && Objects.equals(this.brandVettingSid, other.brandVettingSid) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.vettingId, other.vettingId) && Objects.equals(this.vettingClass, other.vettingClass) && Objects.equals(this.vettingStatus, other.vettingStatus) && Objects.equals((Object)this.vettingProvider, (Object)other.vettingProvider) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.brandSid, this.brandVettingSid, this.dateUpdated, this.dateCreated, this.vettingId, this.vettingClass, this.vettingStatus, this.vettingProvider, this.url});
    }

    public String toString() {
        return "BrandVetting(accountSid=" + this.getAccountSid() + ", brandSid=" + this.getBrandSid() + ", brandVettingSid=" + this.getBrandVettingSid() + ", dateUpdated=" + this.getDateUpdated() + ", dateCreated=" + this.getDateCreated() + ", vettingId=" + this.getVettingId() + ", vettingClass=" + this.getVettingClass() + ", vettingStatus=" + this.getVettingStatus() + ", vettingProvider=" + (Object)((Object)this.getVettingProvider()) + ", url=" + this.getUrl() + ")";
    }

    public static enum VettingProvider {
        CAMPAIGN_VERIFY("campaign-verify");

        private final String value;

        private VettingProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static VettingProvider forValue(String value) {
            return (VettingProvider)Promoter.enumFromString((String)value, (Enum[])VettingProvider.values());
        }
    }
}

