/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.ChannelSender;

public class ChannelSenderReader
extends Reader<ChannelSender> {
    private String pathMessagingServiceSid;
    private Integer pageSize;

    public ChannelSenderReader(String pathMessagingServiceSid) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
    }

    public ChannelSenderReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<ChannelSender> read(TwilioRestClient client) {
        return new ResourceSet<ChannelSender>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ChannelSender> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{MessagingServiceSid}/ChannelSenders";
        path = path.replace("{MessagingServiceSid}", this.pathMessagingServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<ChannelSender> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ChannelSender read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("senders", response.getContent(), ChannelSender.class, client.getObjectMapper());
    }

    @Override
    public Page<ChannelSender> previousPage(Page<ChannelSender> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.MESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ChannelSender> nextPage(Page<ChannelSender> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.MESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ChannelSender> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

