/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.service.PhoneNumberCreator;
import com.twilio.rest.messaging.v1.service.PhoneNumberDeleter;
import com.twilio.rest.messaging.v1.service.PhoneNumberFetcher;
import com.twilio.rest.messaging.v1.service.PhoneNumberReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PhoneNumber
extends Resource {
    private static final long serialVersionUID = 272509077394294L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final com.twilio.type.PhoneNumber phoneNumber;
    private final String countryCode;
    private final List<String> capabilities;
    private final URI url;

    public static PhoneNumberCreator creator(String pathServiceSid, String phoneNumberSid) {
        return new PhoneNumberCreator(pathServiceSid, phoneNumberSid);
    }

    public static PhoneNumberDeleter deleter(String pathServiceSid, String pathSid) {
        return new PhoneNumberDeleter(pathServiceSid, pathSid);
    }

    public static PhoneNumberFetcher fetcher(String pathServiceSid, String pathSid) {
        return new PhoneNumberFetcher(pathServiceSid, pathSid);
    }

    public static PhoneNumberReader reader(String pathServiceSid) {
        return new PhoneNumberReader(pathServiceSid);
    }

    public static PhoneNumber fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PhoneNumber fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PhoneNumber(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="phone_number") com.twilio.type.PhoneNumber phoneNumber, @JsonProperty(value="country_code") String countryCode, @JsonProperty(value="capabilities") List<String> capabilities, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.phoneNumber = phoneNumber;
        this.countryCode = countryCode;
        this.capabilities = capabilities;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final com.twilio.type.PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final List<String> getCapabilities() {
        return this.capabilities;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.dateUpdated, this.phoneNumber, this.countryCode, this.capabilities, this.url);
    }

    public String toString() {
        return "PhoneNumber(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", phoneNumber=" + this.getPhoneNumber() + ", countryCode=" + this.getCountryCode() + ", capabilities=" + this.getCapabilities() + ", url=" + this.getUrl() + ")";
    }
}

