/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1.device;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.microvisor.v1.device.DeviceSecret;

public class DeviceSecretReader
extends Reader<DeviceSecret> {
    private String pathDeviceSid;
    private Integer pageSize;

    public DeviceSecretReader(String pathDeviceSid) {
        this.pathDeviceSid = pathDeviceSid;
    }

    public DeviceSecretReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<DeviceSecret> read(TwilioRestClient client) {
        return new ResourceSet<DeviceSecret>(this, client, this.firstPage(client));
    }

    @Override
    public Page<DeviceSecret> firstPage(TwilioRestClient client) {
        String path = "/v1/Devices/{DeviceSid}/Secrets";
        path = path.replace("{DeviceSid}", this.pathDeviceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MICROVISOR.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<DeviceSecret> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeviceSecret read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("secrets", response.getContent(), DeviceSecret.class, client.getObjectMapper());
    }

    @Override
    public Page<DeviceSecret> previousPage(Page<DeviceSecret> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.MICROVISOR.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DeviceSecret> nextPage(Page<DeviceSecret> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.MICROVISOR.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DeviceSecret> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

