/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.notify.v1.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.notify.v1.service.Notification;
import java.util.List;
import java.util.Map;

public class NotificationCreator
extends Creator<Notification> {
    private String pathServiceSid;
    private String body;
    private Notification.Priority priority;
    private Integer ttl;
    private String title;
    private String sound;
    private String action;
    private Map<String, Object> data;
    private Map<String, Object> apn;
    private Map<String, Object> gcm;
    private Map<String, Object> sms;
    private Map<String, Object> facebookMessenger;
    private Map<String, Object> fcm;
    private List<String> segment;
    private Map<String, Object> alexa;
    private List<String> toBinding;
    private String deliveryCallbackUrl;
    private List<String> identity;
    private List<String> tag;

    public NotificationCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public NotificationCreator setBody(String body) {
        this.body = body;
        return this;
    }

    public NotificationCreator setPriority(Notification.Priority priority) {
        this.priority = priority;
        return this;
    }

    public NotificationCreator setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public NotificationCreator setTitle(String title) {
        this.title = title;
        return this;
    }

    public NotificationCreator setSound(String sound) {
        this.sound = sound;
        return this;
    }

    public NotificationCreator setAction(String action) {
        this.action = action;
        return this;
    }

    public NotificationCreator setData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public NotificationCreator setApn(Map<String, Object> apn) {
        this.apn = apn;
        return this;
    }

    public NotificationCreator setGcm(Map<String, Object> gcm) {
        this.gcm = gcm;
        return this;
    }

    public NotificationCreator setSms(Map<String, Object> sms) {
        this.sms = sms;
        return this;
    }

    public NotificationCreator setFacebookMessenger(Map<String, Object> facebookMessenger) {
        this.facebookMessenger = facebookMessenger;
        return this;
    }

    public NotificationCreator setFcm(Map<String, Object> fcm) {
        this.fcm = fcm;
        return this;
    }

    public NotificationCreator setSegment(List<String> segment) {
        this.segment = segment;
        return this;
    }

    public NotificationCreator setSegment(String segment) {
        return this.setSegment(Promoter.listOfOne(segment));
    }

    public NotificationCreator setAlexa(Map<String, Object> alexa) {
        this.alexa = alexa;
        return this;
    }

    public NotificationCreator setToBinding(List<String> toBinding) {
        this.toBinding = toBinding;
        return this;
    }

    public NotificationCreator setToBinding(String toBinding) {
        return this.setToBinding(Promoter.listOfOne(toBinding));
    }

    public NotificationCreator setDeliveryCallbackUrl(String deliveryCallbackUrl) {
        this.deliveryCallbackUrl = deliveryCallbackUrl;
        return this;
    }

    public NotificationCreator setIdentity(List<String> identity) {
        this.identity = identity;
        return this;
    }

    public NotificationCreator setIdentity(String identity) {
        return this.setIdentity(Promoter.listOfOne(identity));
    }

    public NotificationCreator setTag(List<String> tag) {
        this.tag = tag;
        return this;
    }

    public NotificationCreator setTag(String tag) {
        return this.setTag(Promoter.listOfOne(tag));
    }

    @Override
    public Notification create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Notifications";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.NOTIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Notification creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Notification.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
        if (this.title != null) {
            request.addPostParam("Title", this.title);
        }
        if (this.sound != null) {
            request.addPostParam("Sound", this.sound);
        }
        if (this.action != null) {
            request.addPostParam("Action", this.action);
        }
        if (this.data != null) {
            request.addPostParam("Data", Converter.mapToJson(this.data));
        }
        if (this.apn != null) {
            request.addPostParam("Apn", Converter.mapToJson(this.apn));
        }
        if (this.gcm != null) {
            request.addPostParam("Gcm", Converter.mapToJson(this.gcm));
        }
        if (this.sms != null) {
            request.addPostParam("Sms", Converter.mapToJson(this.sms));
        }
        if (this.facebookMessenger != null) {
            request.addPostParam("FacebookMessenger", Converter.mapToJson(this.facebookMessenger));
        }
        if (this.fcm != null) {
            request.addPostParam("Fcm", Converter.mapToJson(this.fcm));
        }
        if (this.segment != null) {
            for (String prop : this.segment) {
                request.addPostParam("Segment", prop);
            }
        }
        if (this.alexa != null) {
            request.addPostParam("Alexa", Converter.mapToJson(this.alexa));
        }
        if (this.toBinding != null) {
            for (String prop : this.toBinding) {
                request.addPostParam("ToBinding", prop);
            }
        }
        if (this.deliveryCallbackUrl != null) {
            request.addPostParam("DeliveryCallbackUrl", this.deliveryCallbackUrl);
        }
        if (this.identity != null) {
            for (String prop : this.identity) {
                request.addPostParam("Identity", prop);
            }
        }
        if (this.tag != null) {
            for (String prop : this.tag) {
                request.addPostParam("Tag", prop);
            }
        }
    }
}

