/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v1.BulkEligibility;

public class BulkEligibilityFetcher
extends Fetcher<BulkEligibility> {
    private String pathRequestId;

    public BulkEligibilityFetcher(String pathRequestId) {
        this.pathRequestId = pathRequestId;
    }

    @Override
    public BulkEligibility fetch(TwilioRestClient client) {
        String path = "/v1/HostedNumber/Eligibility/Bulk/{RequestId}";
        path = path.replace("{RequestId}", this.pathRequestId.toString());
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BulkEligibility fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return BulkEligibility.fromJson(response.getStream(), client.getObjectMapper());
    }
}

