/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v1.PortingPortability;
import com.twilio.type.PhoneNumber;

public class PortingPortabilityFetcher
extends Fetcher<PortingPortability> {
    private PhoneNumber pathPhoneNumber;
    private String targetAccountSid;

    public PortingPortabilityFetcher(PhoneNumber pathPhoneNumber) {
        this.pathPhoneNumber = pathPhoneNumber;
    }

    public PortingPortabilityFetcher setTargetAccountSid(String targetAccountSid) {
        this.targetAccountSid = targetAccountSid;
        return this;
    }

    @Override
    public PortingPortability fetch(TwilioRestClient client) {
        String path = "/v1/Porting/Portability/PhoneNumber/{PhoneNumber}";
        path = path.replace("{PhoneNumber}", this.pathPhoneNumber.encode("utf-8"));
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PortingPortability fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PortingPortability.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.targetAccountSid != null) {
            request.addQueryParam("TargetAccountSid", this.targetAccountSid);
        }
    }
}

