/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v1.SigningRequestConfiguration;

public class SigningRequestConfigurationReader
extends Reader<SigningRequestConfiguration> {
    private String country;
    private String product;
    private Integer pageSize;

    public SigningRequestConfigurationReader setCountry(String country) {
        this.country = country;
        return this;
    }

    public SigningRequestConfigurationReader setProduct(String product) {
        this.product = product;
        return this;
    }

    public SigningRequestConfigurationReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SigningRequestConfiguration> read(TwilioRestClient client) {
        return new ResourceSet<SigningRequestConfiguration>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SigningRequestConfiguration> firstPage(TwilioRestClient client) {
        String path = "/v1/SigningRequest/Configuration";
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<SigningRequestConfiguration> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SigningRequestConfiguration read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("configurations", response.getContent(), SigningRequestConfiguration.class, client.getObjectMapper());
    }

    @Override
    public Page<SigningRequestConfiguration> previousPage(Page<SigningRequestConfiguration> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SigningRequestConfiguration> nextPage(Page<SigningRequestConfiguration> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SigningRequestConfiguration> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.country != null) {
            request.addQueryParam("Country", this.country);
        }
        if (this.product != null) {
            request.addQueryParam("Product", this.product);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

