/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.AuthorizationDocument;

public class AuthorizationDocumentReader
extends Reader<AuthorizationDocument> {
    private String email;
    private AuthorizationDocument.Status status;
    private Integer pageSize;

    public AuthorizationDocumentReader setEmail(String email) {
        this.email = email;
        return this;
    }

    public AuthorizationDocumentReader setStatus(AuthorizationDocument.Status status) {
        this.status = status;
        return this;
    }

    public AuthorizationDocumentReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<AuthorizationDocument> read(TwilioRestClient client) {
        return new ResourceSet<AuthorizationDocument>(this, client, this.firstPage(client));
    }

    @Override
    public Page<AuthorizationDocument> firstPage(TwilioRestClient client) {
        String path = "/v2/HostedNumber/AuthorizationDocuments";
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<AuthorizationDocument> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthorizationDocument read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("items", response.getContent(), AuthorizationDocument.class, client.getObjectMapper());
    }

    @Override
    public Page<AuthorizationDocument> previousPage(Page<AuthorizationDocument> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AuthorizationDocument> nextPage(Page<AuthorizationDocument> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AuthorizationDocument> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.email != null) {
            request.addQueryParam("Email", this.email);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

