/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.regulatorycompliance.RegulationFetcher;
import com.twilio.rest.numbers.v2.regulatorycompliance.RegulationReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Regulation
extends Resource {
    private static final long serialVersionUID = 10727481359923L;
    private final String sid;
    private final String friendlyName;
    private final String isoCountry;
    private final String numberType;
    private final EndUserType endUserType;
    private final Map<String, Object> requirements;
    private final URI url;

    public static RegulationFetcher fetcher(String pathSid) {
        return new RegulationFetcher(pathSid);
    }

    public static RegulationReader reader() {
        return new RegulationReader();
    }

    public static Regulation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Regulation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Regulation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Regulation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Regulation(@JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="number_type") String numberType, @JsonProperty(value="end_user_type") EndUserType endUserType, @JsonProperty(value="requirements") Map<String, Object> requirements, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.isoCountry = isoCountry;
        this.numberType = numberType;
        this.endUserType = endUserType;
        this.requirements = requirements;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final String getNumberType() {
        return this.numberType;
    }

    public final EndUserType getEndUserType() {
        return this.endUserType;
    }

    public final Map<String, Object> getRequirements() {
        return this.requirements;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Regulation other = (Regulation)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.numberType, other.numberType) && Objects.equals((Object)this.endUserType, (Object)other.endUserType) && Objects.equals(this.requirements, other.requirements) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.friendlyName, this.isoCountry, this.numberType, this.endUserType, this.requirements, this.url});
    }

    public String toString() {
        return "Regulation(sid=" + this.getSid() + ", friendlyName=" + this.getFriendlyName() + ", isoCountry=" + this.getIsoCountry() + ", numberType=" + this.getNumberType() + ", endUserType=" + (Object)((Object)this.getEndUserType()) + ", requirements=" + this.getRequirements() + ", url=" + this.getUrl() + ")";
    }

    public static enum EndUserType {
        INDIVIDUAL("individual"),
        BUSINESS("business");

        private final String value;

        private EndUserType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static EndUserType forValue(String value) {
            return (EndUserType)Promoter.enumFromString((String)value, (Enum[])EndUserType.values());
        }
    }
}

