/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.Regulation;

public class RegulationFetcher
extends Fetcher<Regulation> {
    private String pathSid;
    private Boolean includeConstraints;

    public RegulationFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    public RegulationFetcher setIncludeConstraints(Boolean includeConstraints) {
        this.includeConstraints = includeConstraints;
        return this;
    }

    @Override
    public Regulation fetch(TwilioRestClient client) {
        String path = "/v2/RegulatoryCompliance/Regulations/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Regulation fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Regulation.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.includeConstraints != null) {
            request.addQueryParam("IncludeConstraints", this.includeConstraints.toString());
        }
    }
}

