/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.oauth.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.noauth.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.oauth.v1.TokenCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Token
extends Resource {
    private static final long serialVersionUID = 258139119277894L;
    private final String accessToken;
    private final String refreshToken;
    private final String idToken;
    private final String tokenType;
    private final Long expiresIn;

    public static TokenCreator creator(String grantType, String clientId) {
        return new TokenCreator(grantType, clientId);
    }

    public static Token fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Token.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Token fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Token.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Token(@JsonProperty(value="access_token") String accessToken, @JsonProperty(value="refresh_token") String refreshToken, @JsonProperty(value="id_token") String idToken, @JsonProperty(value="token_type") String tokenType, @JsonProperty(value="expires_in") Long expiresIn) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.idToken = idToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
    }

    public final String getAccessToken() {
        return this.accessToken;
    }

    public final String getRefreshToken() {
        return this.refreshToken;
    }

    public final String getIdToken() {
        return this.idToken;
    }

    public final String getTokenType() {
        return this.tokenType;
    }

    public final Long getExpiresIn() {
        return this.expiresIn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token other = (Token)o;
        return Objects.equals(this.accessToken, other.accessToken) && Objects.equals(this.refreshToken, other.refreshToken) && Objects.equals(this.idToken, other.idToken) && Objects.equals(this.tokenType, other.tokenType) && Objects.equals(this.expiresIn, other.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.refreshToken, this.idToken, this.tokenType, this.expiresIn);
    }

    public String toString() {
        return "Token(accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", idToken=" + this.getIdToken() + ", tokenType=" + this.getTokenType() + ", expiresIn=" + this.getExpiresIn() + ")";
    }
}

