/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.fleet.Deployment;

public class DeploymentReader
extends Reader<Deployment> {
    private String pathFleetSid;
    private Integer pageSize;

    public DeploymentReader(String pathFleetSid) {
        this.pathFleetSid = pathFleetSid;
    }

    public DeploymentReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Deployment> read(TwilioRestClient client) {
        return new ResourceSet<Deployment>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Deployment> firstPage(TwilioRestClient client) {
        String path = "/DeployedDevices/Fleets/{FleetSid}/Deployments";
        path = path.replace("{FleetSid}", this.pathFleetSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Deployment> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Deployment read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("deployments", response.getContent(), Deployment.class, client.getObjectMapper());
    }

    @Override
    public Page<Deployment> previousPage(Page<Deployment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Deployment> nextPage(Page<Deployment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Deployment> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

