/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.hostedNumbers;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.hostedNumbers.AuthorizationDocument;
import java.util.List;

public class AuthorizationDocumentCreator
extends Creator<AuthorizationDocument> {
    private List<String> hostedNumberOrderSids;
    private String addressSid;
    private String email;
    private String contactTitle;
    private String contactPhoneNumber;
    private List<String> ccEmails;

    public AuthorizationDocumentCreator(List<String> hostedNumberOrderSids, String addressSid, String email, String contactTitle, String contactPhoneNumber) {
        this.hostedNumberOrderSids = hostedNumberOrderSids;
        this.addressSid = addressSid;
        this.email = email;
        this.contactTitle = contactTitle;
        this.contactPhoneNumber = contactPhoneNumber;
    }

    public AuthorizationDocumentCreator setHostedNumberOrderSids(List<String> hostedNumberOrderSids) {
        this.hostedNumberOrderSids = hostedNumberOrderSids;
        return this;
    }

    public AuthorizationDocumentCreator setHostedNumberOrderSids(String hostedNumberOrderSids) {
        return this.setHostedNumberOrderSids(Promoter.listOfOne(hostedNumberOrderSids));
    }

    public AuthorizationDocumentCreator setAddressSid(String addressSid) {
        this.addressSid = addressSid;
        return this;
    }

    public AuthorizationDocumentCreator setEmail(String email) {
        this.email = email;
        return this;
    }

    public AuthorizationDocumentCreator setContactTitle(String contactTitle) {
        this.contactTitle = contactTitle;
        return this;
    }

    public AuthorizationDocumentCreator setContactPhoneNumber(String contactPhoneNumber) {
        this.contactPhoneNumber = contactPhoneNumber;
        return this;
    }

    public AuthorizationDocumentCreator setCcEmails(List<String> ccEmails) {
        this.ccEmails = ccEmails;
        return this;
    }

    public AuthorizationDocumentCreator setCcEmails(String ccEmails) {
        return this.setCcEmails(Promoter.listOfOne(ccEmails));
    }

    @Override
    public AuthorizationDocument create(TwilioRestClient client) {
        String path = "/HostedNumbers/AuthorizationDocuments";
        path = path.replace("{HostedNumberOrderSids}", this.hostedNumberOrderSids.toString());
        path = path.replace("{AddressSid}", this.addressSid.toString());
        path = path.replace("{Email}", this.email.toString());
        path = path.replace("{ContactTitle}", this.contactTitle.toString());
        path = path.replace("{ContactPhoneNumber}", this.contactPhoneNumber.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthorizationDocument creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AuthorizationDocument.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.hostedNumberOrderSids != null) {
            for (String prop : this.hostedNumberOrderSids) {
                request.addPostParam("HostedNumberOrderSids", prop);
            }
        }
        if (this.addressSid != null) {
            request.addPostParam("AddressSid", this.addressSid);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
        if (this.contactTitle != null) {
            request.addPostParam("ContactTitle", this.contactTitle);
        }
        if (this.contactPhoneNumber != null) {
            request.addPostParam("ContactPhoneNumber", this.contactPhoneNumber);
        }
        if (this.ccEmails != null) {
            for (String prop : this.ccEmails) {
                request.addPostParam("CcEmails", prop);
            }
        }
    }
}

