/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.twilio.base.bearertoken.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Response;
import com.twilio.http.bearertoken.BearerTokenRequest;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.previewiam.organizations.Account;

public class AccountFetcher
extends Fetcher<Account> {
    private String pathOrganizationSid;
    private String pathAccountSid;

    public AccountFetcher(String pathOrganizationSid, String pathAccountSid) {
        this.pathOrganizationSid = pathOrganizationSid;
        this.pathAccountSid = pathAccountSid;
    }

    @Override
    public Account fetch(BearerTokenTwilioRestClient client) {
        String path = "/Organizations/{OrganizationSid}/Accounts/{AccountSid}";
        path = path.replace("{OrganizationSid}", this.pathOrganizationSid.toString());
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, Domains.PREVIEWIAM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Account fetch failed: Unable to connect to server");
        }
        if (!BearerTokenTwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Account.fromJson(response.getStream(), client.getObjectMapper());
    }
}

