/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.bearertoken.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Response;
import com.twilio.http.bearertoken.BearerTokenRequest;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.previewiam.organizations.RoleAssignment;

public class RoleAssignmentCreator
extends Creator<RoleAssignment> {
    private String pathOrganizationSid;
    private RoleAssignment.PublicApiCreateRoleAssignmentRequest publicApiCreateRoleAssignmentRequest;

    public RoleAssignmentCreator(String pathOrganizationSid, RoleAssignment.PublicApiCreateRoleAssignmentRequest publicApiCreateRoleAssignmentRequest) {
        this.pathOrganizationSid = pathOrganizationSid;
        this.publicApiCreateRoleAssignmentRequest = publicApiCreateRoleAssignmentRequest;
    }

    public RoleAssignmentCreator setPublicApiCreateRoleAssignmentRequest(RoleAssignment.PublicApiCreateRoleAssignmentRequest publicApiCreateRoleAssignmentRequest) {
        this.publicApiCreateRoleAssignmentRequest = publicApiCreateRoleAssignmentRequest;
        return this;
    }

    @Override
    public RoleAssignment create(BearerTokenTwilioRestClient client) {
        String path = "/Organizations/{OrganizationSid}/RoleAssignments";
        path = path.replace("{OrganizationSid}", this.pathOrganizationSid.toString());
        path = path.replace("{PublicApiCreateRoleAssignmentRequest}", this.publicApiCreateRoleAssignmentRequest.toString());
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.POST, Domains.PREVIEWIAM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request, client);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RoleAssignment creation failed: Unable to connect to server");
        }
        if (!BearerTokenTwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return RoleAssignment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(BearerTokenRequest request, BearerTokenTwilioRestClient client) {
        ObjectMapper objectMapper = client.getObjectMapper();
        if (this.publicApiCreateRoleAssignmentRequest != null) {
            request.setBody(RoleAssignment.toJson(this.publicApiCreateRoleAssignmentRequest, objectMapper));
        }
    }
}

