/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.twilio.base.bearertoken.Page;
import com.twilio.base.bearertoken.Reader;
import com.twilio.base.bearertoken.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Response;
import com.twilio.http.bearertoken.BearerTokenRequest;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.previewiam.organizations.User;

public class UserReader
extends Reader<User> {
    private String pathOrganizationSid;
    private String filter;

    public UserReader(String pathOrganizationSid) {
        this.pathOrganizationSid = pathOrganizationSid;
    }

    public UserReader setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public ResourceSet<User> read(BearerTokenTwilioRestClient client) {
        return new ResourceSet<User>(this, client, this.firstPage(client));
    }

    @Override
    public Page<User> firstPage(BearerTokenTwilioRestClient client) {
        String path = "/Organizations/{OrganizationSid}/scim/Users";
        path = path.replace("{OrganizationSid}", this.pathOrganizationSid.toString());
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, Domains.PREVIEWIAM.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<User> pageForRequest(BearerTokenTwilioRestClient client, BearerTokenRequest request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User read failed: Unable to connect to server");
        }
        if (!BearerTokenTwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("Resources", response.getContent(), User.class, client.getObjectMapper());
    }

    @Override
    public Page<User> previousPage(Page<User> page, BearerTokenTwilioRestClient client) {
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEWIAM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<User> nextPage(Page<User> page, BearerTokenTwilioRestClient client) {
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEWIAM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<User> getPage(String targetUrl, BearerTokenTwilioRestClient client) {
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(BearerTokenRequest request) {
        if (this.filter != null) {
            request.addQueryParam("filter", this.filter);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

