/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service.session;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.session.Participant;

public class ParticipantCreator
extends Creator<Participant> {
    private String pathServiceSid;
    private String pathSessionSid;
    private String identifier;
    private String friendlyName;
    private String proxyIdentifier;
    private String proxyIdentifierSid;

    public ParticipantCreator(String pathServiceSid, String pathSessionSid, String identifier) {
        this.pathServiceSid = pathServiceSid;
        this.pathSessionSid = pathSessionSid;
        this.identifier = identifier;
    }

    public ParticipantCreator setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ParticipantCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ParticipantCreator setProxyIdentifier(String proxyIdentifier) {
        this.proxyIdentifier = proxyIdentifier;
        return this;
    }

    public ParticipantCreator setProxyIdentifierSid(String proxyIdentifierSid) {
        this.proxyIdentifierSid = proxyIdentifierSid;
        return this;
    }

    @Override
    public Participant create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Sessions/{SessionSid}/Participants";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{SessionSid}", this.pathSessionSid.toString());
        path = path.replace("{Identifier}", this.identifier.toString());
        Request request = new Request(HttpMethod.POST, Domains.PROXY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identifier != null) {
            request.addPostParam("Identifier", this.identifier);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.proxyIdentifier != null) {
            request.addPostParam("ProxyIdentifier", this.proxyIdentifier);
        }
        if (this.proxyIdentifierSid != null) {
            request.addPostParam("ProxyIdentifierSid", this.proxyIdentifierSid);
        }
    }
}

