/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.routes.v2;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.routes.v2.SipDomain;

public class SipDomainUpdater
extends Updater<SipDomain> {
    private String pathSipDomain;
    private String voiceRegion;
    private String friendlyName;

    public SipDomainUpdater(String pathSipDomain) {
        this.pathSipDomain = pathSipDomain;
    }

    public SipDomainUpdater setVoiceRegion(String voiceRegion) {
        this.voiceRegion = voiceRegion;
        return this;
    }

    public SipDomainUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public SipDomain update(TwilioRestClient client) {
        String path = "/v2/SipDomains/{SipDomain}";
        path = path.replace("{SipDomain}", this.pathSipDomain.toString());
        Request request = new Request(HttpMethod.POST, Domains.ROUTES.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SipDomain update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SipDomain.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.voiceRegion != null) {
            request.addPostParam("VoiceRegion", this.voiceRegion);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

