/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.function;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.function.FunctionVersion;

public class FunctionVersionReader
extends Reader<FunctionVersion> {
    private String pathServiceSid;
    private String pathFunctionSid;
    private Integer pageSize;

    public FunctionVersionReader(String pathServiceSid, String pathFunctionSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathFunctionSid = pathFunctionSid;
    }

    public FunctionVersionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<FunctionVersion> read(TwilioRestClient client) {
        return new ResourceSet<FunctionVersion>(this, client, this.firstPage(client));
    }

    @Override
    public Page<FunctionVersion> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Functions/{FunctionSid}/Versions";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{FunctionSid}", this.pathFunctionSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.SERVERLESS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<FunctionVersion> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FunctionVersion read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("function_versions", response.getContent(), FunctionVersion.class, client.getObjectMapper());
    }

    @Override
    public Page<FunctionVersion> previousPage(Page<FunctionVersion> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SERVERLESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<FunctionVersion> nextPage(Page<FunctionVersion> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SERVERLESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<FunctionVersion> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

